//
//  GSFloatArray.h
//  GSFontTools
//
//  Created by Georg Seifert on 21/06/12.
//
//

#import <Foundation/Foundation.h>

@interface GSFloatArray : NSObject <NSCopying>

- (instancetype)initWithCapacity:(NSUInteger)capacity;
- (instancetype)initWithFloats:(float *)floats count:(NSUInteger)count;
- (float)elementAtIndex:(NSUInteger)idx;
- (void)setElement:(float)element atIndex:(NSUInteger)idx;
- (void)addElement:(float)element;
- (float *)elements;
- (NSUInteger)count;
- (void)extend:(NSUInteger)newLength;

- (instancetype)copySubarrayWithRange:(NSRange)range;

- (float)lastElement;
- (float)firstElement;
- (float)pop;

- (void)removeElementAtIndex:(NSUInteger)idx;
- (void)insertElement:(float)element atIndex:(NSUInteger)idx;
- (void)addElementsFromArray:(GSFloatArray *)array;

- (NSUInteger)firstIndexOfElement:(float)element;
- (NSUInteger)firstIndexOfElement:(float)element inRange:(NSRange)range;
- (NSUInteger)lastIndexOfElement:(float)element;
@end
